<?php
/**
 * JefCounts 统计系统 - 核心配置文件
 * 
 * ⚠️ 安全提示：
 * 1. 生产环境请使用强密码
 * 2. 确保此文件不被 Git 追踪（已在 .gitignore 中）
 * 3. 文件权限建议设置为 640 或 600
 * 4. 定期更换数据库密码
 */

// =============================================
// 1. 数据库配置
// =============================================
define('DB_HOST', 'localhost');
define('DB_PORT', '3306');
define('DB_NAME', 'DB_NAME');
define('DB_USER', 'DB_NAME');
define('DB_PASS', 'DB_PASS');

// 数据库连接
try {
    $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8mb4";
    $pdo = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
        PDO::ATTR_EMULATE_PREPARES => false
    ]);
} catch (PDOException $e) {
    die('数据库连接失败: ' . $e->getMessage());
}

// =============================================
// 2. 系统配置
// =============================================
define('APP_NAME', '极简统计');
define('APP_VERSION', '1.0.0');

// 时区设置（重要！确保与服务器时区一致）
date_default_timezone_set('Asia/Shanghai');

// Session 过期时间（秒）
define('SESSION_LIFETIME', 7200); // 2小时

// 数据保留天数（自动清理，0表示不自动清理）
define('DATA_RETENTION_DAYS', 365);

// 管理员配置文件路径
define('ADMIN_CONFIG_FILE', __DIR__ . '/admin.json');

// 设置文件路径
define('SETTINGS_FILE', __DIR__ . '/settings.json');

// 安装锁文件路径
define('INSTALL_LOCK_FILE', __DIR__ . '/installed.lock');

// =============================================
// 3. 安全配置
// =============================================
// 注意：Session 安全配置已在 public/index.php 中设置（必须在 session_start() 之前）

// 生产环境错误显示（开发时可设为1）
if (defined('PRODUCTION') && PRODUCTION === true) {
    ini_set('display_errors', 0);
    ini_set('log_errors', 1);
    ini_set('error_log', __DIR__ . '/../data/error.log');
} else {
    ini_set('display_errors', 1);
    error_reporting(E_ALL);
}

// =============================================
// 4. 性能配置
// =============================================

// OPcache建议配置（在php.ini中设置）
/*
opcache.enable=1
opcache.memory_consumption=128
opcache.max_accelerated_files=10000
opcache.revalidate_freq=2
*/

// =============================================
// 配置加载完成
// =============================================
?>